/*
 * Decompiled with CFR 0.152.
 */
package com.jtorleonstudios.libraryferret.gui;

import com.jtorleonstudios.libraryferret.gui.AbstractScreen;
import com.jtorleonstudios.libraryferret.gui.AbstractUI;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.opengl.GL11;

public class ScrollableTextUI
extends AbstractUI {
    private List<String> texts;
    private final int barLeft;
    private boolean scrolling;
    private double scrollDistance;

    public ScrollableTextUI(AbstractScreen parent, String text, int x, int y, int width, int height) {
        super(parent, x, y, width, height);
        int var10001 = this.right;
        this.barLeft = var10001 - 6;
        this.texts = this.resizeTextToWidth(text);
        this.scrolling = false;
        this.scrollDistance = 0.0;
    }

    public void m_88315_(@NotNull GuiGraphics ctx, int mouseX, int mouseY, float partialTicks) {
        double scale = this.parent.getWindow().m_85449_();
        Tesselator tess = Tesselator.m_85913_();
        BufferBuilder world = tess.m_85915_();
        RenderSystem.setShader(GameRenderer::m_172820_);
        GL11.glEnable((int)3089);
        GL11.glScissor((int)((int)((double)this.left * scale)), (int)((int)((double)this.parent.getWindow().m_85442_() - (double)this.bottom * scale)), (int)((int)((double)this.width * scale)), (int)((int)((double)this.height * scale)));
        this.renderTexts(this.texts, ctx, this.left + this.getInnerPadding(), this.getInnerPadding() + (int)((double)this.y - this.scrollDistance), 0xFFFFFF);
        if (this.requireScroll()) {
            int extraHeight;
            int barHeight = this.getBarHeight();
            int barTop = (int)this.scrollDistance * (this.height - barHeight) / (extraHeight = this.getContentHeight() - this.height) + this.top;
            if (barTop < this.top) {
                barTop = this.top;
            }
            RenderSystem.enableBlend();
            RenderSystem.setShader(GameRenderer::m_172811_);
            world.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
            world.m_5483_((double)this.barLeft, (double)this.bottom, 0.0).m_6122_(0, 0, 0, 255).m_5752_();
            world.m_5483_((double)(this.barLeft + 6), (double)this.bottom, 0.0).m_6122_(0, 0, 0, 255).m_5752_();
            world.m_5483_((double)(this.barLeft + 6), (double)this.top, 0.0).m_6122_(0, 0, 0, 255).m_5752_();
            world.m_5483_((double)this.barLeft, (double)this.top, 0.0).m_6122_(0, 0, 0, 255).m_5752_();
            tess.m_85914_();
            world.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
            world.m_5483_((double)this.barLeft, (double)(barTop + barHeight), 0.0).m_6122_(128, 128, 128, 255).m_5752_();
            world.m_5483_((double)(this.barLeft + 6), (double)(barTop + barHeight), 0.0).m_6122_(128, 128, 128, 255).m_5752_();
            world.m_5483_((double)(this.barLeft + 6), (double)barTop, 0.0).m_6122_(128, 128, 128, 255).m_5752_();
            world.m_5483_((double)this.barLeft, (double)barTop, 0.0).m_6122_(128, 128, 128, 255).m_5752_();
            tess.m_85914_();
            world.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
            world.m_5483_((double)this.barLeft, (double)(barTop + barHeight - 1), 0.0).m_6122_(192, 192, 192, 255).m_5752_();
            world.m_5483_((double)(this.barLeft + 6 - 1), (double)(barTop + barHeight - 1), 0.0).m_6122_(192, 192, 192, 255).m_5752_();
            world.m_5483_((double)(this.barLeft + 6 - 1), (double)barTop, 0.0).m_6122_(192, 192, 192, 255).m_5752_();
            world.m_5483_((double)this.barLeft, (double)barTop, 0.0).m_6122_(192, 192, 192, 255).m_5752_();
            tess.m_85914_();
        }
        RenderSystem.disableBlend();
        GL11.glDisable((int)3089);
    }

    public boolean m_6050_(double mouseX, double mouseY, double scroll) {
        if (!super.m_6050_(mouseX, mouseY, scroll) && scroll != 0.0 && this.requireScroll()) {
            this.scrollDistance += -scroll * 20.0;
            this.applyScrollLimits();
            return true;
        }
        return false;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (super.m_6375_(mouseX, mouseY, button)) {
            return false;
        }
        this.scrolling = this.requireScroll() && button == 0 && mouseX >= (double)this.barLeft && mouseX < (double)(this.barLeft + 6);
        return this.scrolling;
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (super.m_6348_(mouseX, mouseY, button)) {
            return false;
        }
        this.scrolling = !this.scrolling;
        return !this.scrolling;
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (!super.m_7979_(mouseX, mouseY, button, deltaX, deltaY) && this.scrolling) {
            int maxScroll = this.height - this.getBarHeight();
            double moved = deltaY / (double)maxScroll;
            this.scrollDistance += (double)(this.getContentHeight() - this.height) * moved;
            this.applyScrollLimits();
            return true;
        }
        return false;
    }

    private void applyScrollLimits() {
        int max = this.getContentHeight() - this.height;
        if (max < 0) {
            max /= 2;
        }
        this.scrollDistance = this.scrollDistance < 0.0 ? 0.0 : Math.min(this.scrollDistance, (double)max);
    }

    public void setTexts(String text) {
        this.texts = this.resizeTextToWidth(text);
    }

    private int getContentHeight() {
        int var10000 = this.texts.size();
        Objects.requireNonNull(this.parent.getFontRenderer());
        int h = var10000 * 9 + this.getInnerPadding() * 2;
        if (h < this.bottom - this.top - 8) {
            h = this.bottom - this.top - 8;
        }
        return h;
    }

    private int getBarHeight() {
        int barHeight = this.height * this.height / this.getContentHeight();
        if (barHeight < 32) {
            barHeight = 32;
        }
        if (barHeight > this.height * 2) {
            barHeight = this.height * 2;
        }
        return barHeight;
    }

    private boolean requireScroll() {
        return this.getContentHeight() > this.height;
    }

    private int getInnerPadding() {
        return 6;
    }
}

